/********************************************************************
 SQORA.H - This is the include file for ODBC options that are 
            specific to the Oracle ODBC Driver.


 (C) Copyright 1993,1997 By Oracle Corporation
*********************************************************************/

#ifndef SQORA_ORACLE
#define SQORA_ORACLE

/************************************************************************/
/* Oracle ODBC Driver SQL data types.  Oracle is registered to use the  */
/* values -400 to -449 inclusive.                                       */
/************************************************************************/

#define SQL_ORCL_BFILE          (-400)
#define SQL_ORCL_CLOB           (-401)
#define SQL_ORCL_BLOB           (-402)
#define SQL_ORCL_NCLOB          (-403)
#define SQL_ORCL_RSET           (-404)

#define SQL_ORCL_TYPE_MIN       SQL_ORCL_RSET
#define SQL_ORCL_TYPE_MAX       SQL_ORCL_BFILE
#define SQL_ORCLATTR_COLUMN_PROP (-405)
#define SQL_ORCLATTR_DESC_COLUMN_PROP SQL_ORCLATTR_COLUMN_PROP 

/*
** SQLSetConnectAttr Attributes
*/
#define SQL_ORCLATTR_FAILOVER_CALLBACK     (-448)
#define SQL_ORCLATTR_FAILOVER_HANDLE     (-449)


/*
** Failover codes.  These values map directly to the OCI
** failover codes.
*/
#define ODBC_FO_END          0x00000001     /* OCI_FO_END */
#define ODBC_FO_ABORT        0x00000002     /* OCI_FO_ABORT */
#define ODBC_FO_REAUTH       0x00000004     /* OCI_FO_REAUTH */
#define ODBC_FO_BEGIN        0x00000008     /* OCI_FO_BEGIN */
#define ODBC_FO_ERROR        0x00000010     /* OCI_FO_ERROR */


#endif  /* #ifndef SQORA_ORACLE */
